import pandas as pd  
import pickle  
  
# Load the dataset  
credit_customers = pd.read_csv("credit_customers.csv")  

stable_employment_customers = credit_customers[credit_customers['employment'].isin(['>=7', '4<=X<7'])]
unstable_employment_customers = credit_customers[~credit_customers['employment'].isin(['>=7', '4<=X<7'])]
approval_rates_stable_employment = stable_employment_customers['class'].value_counts(normalize=True)
approval_rates_unstable_employment = unstable_employment_customers['class'].value_counts(normalize=True)
increase_percentage = ((approval_rates_stable_employment['good'] - approval_rates_unstable_employment['good']) / approval_rates_unstable_employment['good']) * 100

print("increase_percentage is:")
print(increase_percentage)
pickle.dump(increase_percentage, open("./ref_result/increase_percentage.pkl","wb"))